/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: mx_strerror.c,v 1.14 2005/06/29 00:23:16 eugene Exp $";

#include <stdio.h>
#include "mx_auto_config.h"
#include "myriexpress.h"

const char *
mx_strerror(mx_return_t return_code)
{
  static char buf[80];

  switch (return_code) {
  case MX_SUCCESS:
    return "Successful return.";
  case MX_ALREADY_INITIALIZED:
    return "MX already initialized.";
  case MX_NOT_INITIALIZED:
    return "MX not initialized.";
  case MX_BOARD_UNKNOWN:
    return "Board specified does not exist.";
  case MX_BAD_ENDPOINT:
    return "Endpoint is not valid.";
  case MX_BAD_SEG_LIST:
    return "Bad segment list.";
  case MX_BAD_SEG_MEM:
    return "One segment is invalid.";
  case MX_BAD_SEG_CNT:
    return "Too many segments.";
  case MX_BAD_MATCH_MASK:
    return "Bad match mask.";
  case MX_NO_RESOURCES:
    return "No resources.";
  case MX_BAD_ADDR_LIST:
    return "Bad address list.";
  case MX_BAD_ADDR_COUNT:
    return "Bad address count.";
  case MX_BAD_ROOT:
    return "Root index out of range.";
  case MX_NOT_COMPLETED:
    return "Not completed.";
  case MX_BUSY:
    return "Busy";
  case MX_BAD_INFO_KEY:
    return "Bad info key.";
  case MX_BAD_INFO_VAL:
    return "Bad info value pointer.";
  case MX_BAD_NIC:
    return "Bad nic id.";
  case MX_BAD_PARAM_LIST:
    return "Bad parameter list.";
  case MX_BAD_PARAM_NAME:
    return "Bad parameter name.";
  case MX_BAD_PARAM_VAL:
    return "Bad parameter value.";
  case MX_BAD_HOSTNAME_ARGS:
    return "Bad arguments to hostname_to_ni_ids";
  case MX_HOST_NOT_FOUND:
    return "Hostname not found";
  case MX_BAD_BAD_BAD:
    return "Something BAD happened.";
  case MX_FAILURE:
    return "Failure!";
  default:
    sprintf(buf, "Unknown error code: %d", return_code);
    return buf;
  }
}
